
//
// To jest przykadowy kod z podrozdziau 19.5.3 Gwarancje ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <iostream>
#include <stdexcept>
#include <vector>

using std::vector;

//------------------------------------------------------------------------------

namespace N1
{
    vector<int>* make_vec()    // Tworzy peny wektor.
    {
        vector<int>* p = new vector<int>;    // Alokacja w pamici wolnej.
        //  Napenia wektor danymi. Tu moe zosta zgoszony wyjtek.
        return p;
    }
}

//------------------------------------------------------------------------------

namespace N2
{
    vector<int>* make_vec()    // Tworzy peny wektor.
    {
        vector<int>* p = new vector<int>;    // Alokacja w pamici wolnej.
        try {
            // Napenia wektor danymi. Tu moe zosta zgoszony wyjtek.
            return p;
        }
        catch (...) {
            delete p;    // Lokalne czyszczenie.
            throw;       // Ponowne zgoszenie wyjtku, aby umoliwi wywoujcemu poradzenie sobie
                         // z tym, e jaka funkcja nie bya w stanie wykona swojego zadania.
        }
    }
}

//------------------------------------------------------------------------------

int main()
try
{
    vector<int>* p = N1::make_vec();
    vector<int>* q = N2::make_vec();
    delete q;
    delete p;
}
catch (std::exception& e) {
    std::cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    std::cerr << "Ojej: nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
